function design = ana12_1d(n, d, ANAI2)
%ana12_1d Generates a 1D ANAI-2 array.
%Syntax:
%   design = ana12_1d(n, wavelength/2, 'ANAI-2 Array');
%Inputs:
%   n - Parameter pair.
%   d - Inter-element spacing.
%   name - Custom name of the array. Default is 'ANAI-2 array (m, n)'.
%Outputs:
%   design - An array design struct.
if n <= 7
    error('Sensor amount must larger than 7.');
end
% ========= array configuration ============
% ========= decide spacing
if mod(n,2)==1
    n1 = (n-1)/2;
else
    n1 = n/2;
end
n2 = n-n1;
k1 = [];
k1 = [0:floor((n1-1)/2)];
k2 = [];
k2 = [1:floor(n1/2)];

L1 = ceil((n1 +1)/2);
V22 = [];
LEN_k2 = length(k2);
for V22_count = 1:LEN_k2
    V22(V22_count) = n1 - 2*k2(V22_count);
end
V22 = [0 V22];
V21 = [];
LEN_k1 = length(k1);
for V21_count = 1:LEN_k1
    V21(V21_count) = n1 - 2*k1(V21_count)-1;
end
V21 = [0 n1 V21];
L=[];
LEN_V21 = length(V21);
for left_count = 1:LEN_V21
    L(left_count)=n1+1-V21(left_count);
end
%L=sort(L);
R=[];
LEN_V22 = length(V22);
for right_count = 1:LEN_V22
    R(right_count)=V22(right_count) + (n1+1)*n2;
end
M=[];
for middle_count = 1:n2
    M(middle_count) = middle_count*(n1+1);
end





if d <= 0 || ~isreal(d)
    error('d must be a positive real number.');
end
if nargin <= 2
    name = sprintf('ANAI-2 %d sensors', n);
elseif ~ischar(name)
    error('Name must be a string.');
end
A = [L M R];
A = unique(A);
A = sort(A);
design.element_indices = A;
%design.element_indices = union(design.element_indices, (n1*n2+n2+n1-2));
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.dim = 1;
design.type = 'ANAI-2';
design.name = name;
end